<?php
session_start();

// Hardcoded API key (same for all branches)
$fixed_api_key = 'MSALNRHZTF9ZGU1JA2OJMJ7ZPCVVSI371PUVNHYP';

// Simple login credentials (change these later)
$valid_username = 'admin';
$valid_password = 'smslab123';

// Login check
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        if ($username === $valid_username && $password === $valid_password) {
            $_SESSION['logged_in'] = true;
        } else {
            $login_error = "Invalid username or password.";
        }
    }
    if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>SMSLab Login</title>
            <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
        </head>
        <body class="bg-gray-100 flex items-center justify-center min-h-screen">
            <div class="bg-white p-8 rounded-lg shadow-lg w-full max-w-sm">
                <h2 class="text-3xl font-bold mb-6 text-center text-blue-600">SMSLab Login</h2>
                <?php if (isset($login_error)) { echo "<p class='text-red-500 mb-4 text-center'>$login_error</p>"; } ?>
                <form method="post" class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Username</label>
                        <input type="text" name="username" class="mt-1 block w-full p-3 border rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Password</label>
                        <input type="password" name="password" class="mt-1 block w-full p-3 border rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    <button type="submit" name="login" class="w-full bg-blue-600 text-white p-3 rounded-md hover:bg-blue-700 transition">Login</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Database connection
try {
    $db = new PDO('sqlite:smslab_config.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Handle form submissions
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['submit_config'])) {
        $branch_id = trim($_POST['branch_id'] ?? '');
        $device_id = trim($_POST['device_id'] ?? '');

        if (empty($branch_id) || empty($device_id)) {
            $message = "<p class='text-red-500'>All fields are required.</p>";
        } elseif (!preg_match('/^[a-zA-Z0-9]+$/', $branch_id)) {
            $message = "<p class='text-red-500'>Branch ID must be alphanumeric.</p>";
        } else {
            $stmt = $db->prepare("INSERT OR REPLACE INTO configs (branch_id, api_key, device_id) VALUES (?, ?, ?)");
            $stmt->execute([$branch_id, $fixed_api_key, $device_id]);
            $message = "<p class='text-green-500'>Configuration saved! Use this API URL in Ramom: <strong>https://grwebdevs.com/smslab_proxy.php?mobile_number=[app_number]&message=[app_message]&branch_id=" . htmlspecialchars($branch_id) . "</strong></p>";
        }
    } elseif (isset($_POST['delete_config'])) {
        $branch_id = $_POST['branch_id'] ?? '';
        if (!empty($branch_id)) {
            $stmt = $db->prepare("DELETE FROM configs WHERE branch_id = ?");
            $stmt->execute([$branch_id]);
            $message = "<p class='text-green-500'>Configuration for Branch ID " . htmlspecialchars($branch_id) . " deleted.</p>";
        }
    } elseif (isset($_POST['logout'])) {
        session_destroy();
        header("Location: config.php");
        exit;
    }
}

// Fetch existing configurations
$stmt = $db->query("SELECT branch_id, device_id FROM configs ORDER BY branch_id");
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMSLab Configuration</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .table-container { max-height: 200px; overflow-y: auto; }
    </style>
</head>
<body class="bg-gray-100 min-h-screen p-6">
    <div class="max-w-4xl mx-auto bg-white p-8 rounded-lg shadow-lg">
        <h2 class="text-3xl font-bold mb-6 text-center text-blue-600">GR SMS GATEWAY Configuration Manager</h2>
        <p class="text-gray-600 mb-6 text-center">Configure your branch to send SMS via GR SMS GATEWAY. Enter your Branch ID and Device ID below.</p>
        
        <?php if (!empty($message)) { echo "<div class='mb-6'>$message</div>"; } ?>

        <!-- Configuration Form -->
        <form method="post" class="space-y-6 mb-8">
            <div>
                <label class="block text-sm font-medium text-gray-700">Branch ID</label>
                <input type="text" name="branch_id" class="mt-1 block w-full p-3 border rounded-md focus:ring-blue-500 focus:border-blue-500" required placeholder="e.g., 2">
                <p class="text-sm text-gray-500 mt-1">Your unique DPS SYSTEM branch ID (alphanumeric).</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Device ID</label>
                <input type="text" name="device_id" class="mt-1 block w-full p-3 border rounded-md focus:ring-blue-500 focus:border-blue-500" required placeholder="e.g., 8e7adc4c44dc9d09">
                <p class="text-sm text-gray-500 mt-1">Your GR SGATEWAY Device ID (from GR SMS GATEWAY dashboard).</p>
            </div>
            <button type="submit" name="submit_config" class="w-full bg-blue-600 text-white p-3 rounded-md hover:bg-blue-700 transition">Save Configuration</button>
        </form>

        <!-- Existing Configurations -->
        <?php if (!empty($configs)) { ?>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Existing Configurations</h3>
            <div class="table-container">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-200">
                            <th class="p-3 text-sm font-medium text-gray-700">Branch ID</th>
                            <th class="p-3 text-sm font-medium text-gray-700">Device ID</th>
                            <th class="p-3 text-sm font-medium text-gray-700">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($configs as $config) { ?>
                            <tr class="border-b">
                                <td class="p-3"><?php echo htmlspecialchars($config['branch_id']); ?></td>
                                <td class="p-3"><?php echo htmlspecialchars($config['device_id']); ?></td>
                                <td class="p-3">
                                    <form method="post" onsubmit="return confirm('Are you sure you want to delete this configuration?');">
                                        <input type="hidden" name="branch_id" value="<?php echo htmlspecialchars($config['branch_id']); ?>">
                                        <button type="submit" name="delete_config" class="text-red-500 hover:underline">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        <?php } ?>

        <!-- Logout -->
        <form method="post" class="mt-8">
            <button type="submit" name="logout" class="w-full bg-red-600 text-white p-3 rounded-md hover:bg-red-700 transition">Logout</button>
        </form>
    </div>
</body>
</html>